"use client";

import { useEffect } from "react";

export default function GlobalError({
  error,
}: {
  error: Error & { digest?: string };
  reset: () => void;
}) {
  useEffect(() => {
    // Log the error to an error reporting service
    console.error(error);
  }, [error]);

  return (
    <html>
      <body>
        <div className="grid h-screen w-full place-content-center bg-gray-400 text-white">
          <h2 className="text-center text-3xl">Something went wrong!</h2>
          {/* <button onClick={() => reset()}>Try again</button> */}
        </div>
      </body>
    </html>
  );
}
