import React from "react";

type ArrowProps = {
  direction: "top" | "down" | "right" | "left";
  height?: number;
  width?: number;
};

export default function Arrow({
  direction,
  height = 15,
  width = 15,
}: ArrowProps) {
  let transformVal;

  switch (direction) {
    case "left":
      transformVal = "!rotate-90 rtl:!-rotate-90";
      break;
    case "right":
      transformVal = "!-rotate-90 rtl:!rotate-90";
      break;
    case "top":
      transformVal = "rotate-180";
      break;
    case "down":
      transformVal = "";
      break;
    default:
      transformVal = "";
  }
  return (
    <svg
      className={`fill-current ${transformVal} transition-transform duration-300 ease-in-out `}
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 512 512"
      height={height}
      width={width}
    >
      <path d="M233.4 406.6c12.5 12.5 32.8 12.5 45.3 0l192-192c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L256 338.7 86.6 169.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l192 192z" />
    </svg>
  );
}

export const RightArrow = () => {
  return (
    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512">
      <path d="M310.6 233.4c12.5 12.5 12.5 32.8 0 45.3l-192 192c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L242.7 256 73.4 86.6c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l192 192z" />
    </svg>
  );
};
export const LeftArrow = () => {
  return (
    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512">
      <path d="M9.4 233.4c-12.5 12.5-12.5 32.8 0 45.3l192 192c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L77.3 256 246.6 86.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-192 192z" />
    </svg>
  );
};
