"use client";
import { ChangeEvent, FormEvent, useState } from "react";
import OrderForm from "../order-form/OrderForm";

const coarseOptions = [
  { label: "P.40", value: "P.40" },
  { label: "P.60", value: "P.60" },
  { label: "P.80", value: "P.80" },
  { label: "P.120", value: "P.120" },
];
const productPrice = 85;

export default function ProductOptions() {
  const [formValues, setFormValues] = useState({
    quantity: 1,
    coarseDegree: "",
  });

  const [error, setError] = useState("");
  const [isOpen, setIsOpen] = useState(false);

  const price = productPrice * formValues.quantity;

  function handleSubmit(e: FormEvent) {
    e.preventDefault();

    if (!formValues.coarseDegree) {
      setError("من فضلك اختر درجة الخشانة");
      return;
    } else {
      setError("");
      setIsOpen(true);
    }
  }
  return (
    <>
      <form onSubmit={handleSubmit}>
        <div className="mb-4 flex items-start gap-1">
          <span className="text-2xl font-semibold">{price}</span>
          <span className="text-sm">جنيه</span>
        </div>
        <div className="flex items-center gap-2">
          <span className="">أبعاد المنتج:</span>
          <span className="">60*30*6</span>
        </div>
        <div className="mt-4 items-center gap-2">
          {/* <label htmlFor="coarse-degree" className="mb-2 block">
            درجة الخشانة:
          </label> */}
          <select
            id="coarse-degree"
            className="block rounded-md border outline-none"
            value={formValues.coarseDegree}
            onChange={(e: ChangeEvent<HTMLSelectElement>) =>
              setFormValues((prev) => ({
                ...prev,
                coarseDegree: e.target.value,
              }))
            }
          >
            <option value="" hidden>
              اختر درجة الخشانة
            </option>
            {coarseOptions.map((opt) => (
              <option key={opt.value} value={opt.value}>
                {opt.label}
              </option>
            ))}
          </select>
        </div>
        {error && <p className="text-sm font-medium text-red-600">{error}</p>}
        <div className="mt-4  items-center gap-2">
          <label htmlFor="quantity" className="mb-2 block">
            الكمية:
          </label>
          <div className="flex items-center gap-2">
            <button
              type="button"
              onClick={() =>
                setFormValues((prev) => ({
                  ...prev,
                  quantity: formValues.quantity + 1,
                }))
              }
              className="grid size-8 place-content-center rounded-md border "
            >
              +
            </button>
            <span className="px-2">{formValues.quantity}</span>
            {/* <input
              className="w-[50px] text-center"
              type="text"
              id="quantity"
              value={formValues.quantity}
              onChange={(e: ChangeEvent<HTMLInputElement>) =>
                setFormValues((prev) => ({
                  ...prev,
                  quantity: Number(e.target.value),
                }))
              }
            /> */}
            <button
              className={`grid size-8 place-content-center rounded-md ${formValues.quantity === 1 ? "bg-gray-100 text-stone-800" : "border"}`}
              type="button"
              onClick={() => {
                if (formValues.quantity === 1) return;
                setFormValues((prev) => ({
                  ...prev,
                  quantity: formValues.quantity - 1,
                }));
              }}
            >
              -
            </button>
          </div>
        </div>
        <button
          type="submit"
          className="mt-4 w-[300px] max-w-full rounded-md bg-secondary-500 px-4 py-2 text-center text-white transition-all duration-300 ease-in-out hover:bg-secondary-400 "
        >
          طلب شراء
        </button>
      </form>
      {isOpen && (
        <OrderForm
          close={() => setIsOpen(false)}
          price={price}
          coarseDegree={formValues.coarseDegree}
          quantity={formValues.quantity}
        />
      )}
    </>
  );
}
