import { useEffect, useRef, useState } from "react";

export function useSticky(stickyThreshold: number) {
  const [isSticky, setIsSticky] = useState(false);
  const prevScrollY = useRef(0);

  useEffect(() => {
    const handleScroll = () => {
      const scrollY = window.scrollY;

      const shouldUpdate =
        (scrollY > stickyThreshold && prevScrollY.current < stickyThreshold) ||
        (scrollY <= stickyThreshold && prevScrollY.current > stickyThreshold);

      if (shouldUpdate) {
        setIsSticky(scrollY > stickyThreshold);
        prevScrollY.current = scrollY;
      }
    };
    window.addEventListener("scroll", handleScroll);

    return () => {
      window.removeEventListener("scroll", handleScroll);
    };
  }, [stickyThreshold]);

  return isSticky;
}
